package gov.va.genisis2.ts.dto;

import java.io.Serializable;

public class MetaInterOntologyLinkDTO implements Serializable, Comparable<MetaInterOntologyLinkDTO> {

	private static final long serialVersionUID = 6158882124607101922L;

	private String name;
	private String uri;
	private String ontologyName;
	private Boolean isMvpPredicate;

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the uri
	 */
	public String getUri() {
		return uri;
	}

	/**
	 * @param uri
	 *            the uri to set
	 */
	public void setUri(String uri) {
		this.uri = uri;
	}

	/**
	 * @return the ontologyName
	 */
	public String getOntologyName() {
		return ontologyName;
	}

	/**
	 * @param ontologyName
	 *            the ontologyName to set
	 */
	public void setOntologyName(String ontologyName) {
		this.ontologyName = ontologyName;
	}

	/**
	 * @return the isMvpPredicate
	 */
	public Boolean getIsMvpPredicate() {
		return isMvpPredicate;
	}

	/**
	 * @param isMvpPredicate
	 *            the isMvpPredicate to set
	 */
	public void setIsMvpPredicate(Boolean isMvpPredicate) {
		this.isMvpPredicate = isMvpPredicate;
	}

	/**
	 * sort interOntologyLinks on 'name' attribute
	 */
	public int compareTo(MetaInterOntologyLinkDTO object) {
		String localOntologyName = (null != object) ? object.getOntologyName() : null;
		return (null != localOntologyName) ? this.ontologyName.compareToIgnoreCase(localOntologyName) : -1;
	}
}
